<?php

namespace App\Http\Controllers\User;

use App\Constants\Status;
use App\Http\Controllers\Controller;
use App\Models\Order;

class OrderController extends Controller {
    public function order() {
        $pageTitle = "My Orders";
        $orders    = Order::where('user_id', auth()->id())
            ->where(function ($query) {
                $query->orWhere('payment_status', Status::PAYMENT_ONLINE)
                    ->orWhere(function ($query) {
                        $query->where('payment_type', Status::PAYMENT_OFFLINE)
                            ->where('payment_status', Status::PAYMENT_INITIATE);
                    });
            })
            ->latest()->with('deposit')->paginate(getPaginate());
        return view('Template::user.order.index', compact('pageTitle', 'orders'));
    }

    public function details($id) {
        $pageTitle = 'Order Detail';
        $order     = Order::where('id', $id)->where('user_id', auth()->id())->with(['orderDetail.product', 'coupon', 'shipping', 'deposit.gateway', 'user'])->firstOrFail();
        return view('Template::user.order.detail', compact('pageTitle', 'order'));
    }
}
